import React from 'react';
import cn from 'classnames';
import Tooltip from '@material-ui/core/Tooltip';
import info from 'resources/images/info.svg';
import infoWhite from 'resources/images/info_white.svg';
import useStyles from './styles';

type Props = {
    children: ReactElement,
    placement: string,
    styles: object,
    iconClasses: object,
    iconType: 'white',
    classes: {
        [key: string]: string
    }
};

function InfoTooltip({
    children,
    placement = 'right',
    styles = {},
    iconClasses,
    iconType
}: Props) {
    const classes = useStyles();
    return (
        <Tooltip
            classes={{
                tooltip: classes.tooltipContainer,
                popper: styles.popper ? styles.popper : undefined,
                ...styles
            }}
            interactive
            title={children}
            placement={placement}
        >
            <img
                className={cn(classes.headerIcon, iconClasses)}
                src={iconType === 'white' ? infoWhite : info}
                alt="Info Icon"
            />
        </Tooltip>
    );
}

export default InfoTooltip;
